﻿using SnapsLibrary;
using System.Collections.Generic;

using Newtonsoft.Json;
using System;

class Ch11_05_TimeTrackerFriendly
{
    class Contact
    {
        private string contactName;

        static public string ValidateName(string newName)
        {
            if (newName == "")
                return "Nazwa nie może być pustym łańcuchem znaków\n";

            return "";
        }

        public string ContactName
        {
            get
            {
                return contactName;
            }

            set
            {
                string message = ValidateName(value);
                if (message != "")
                    throw new Exception(message);

                contactName = value;
            }
        }

        private string contactAddress;

        static public string ValidateAddress(string newAddress)
        {
            if (newAddress == "")
                return "Adres nie może być pustym łańcuchem znaków\n";

            return "";
        }


        public string ContactAddress
        {
            get
            {
                return contactAddress;
            }

            set
            {
                contactAddress = value;
            }
        }

        private string contactPhone;

        static public string ValidatePhone(string newPhone)
        {
            if (newPhone == "")
                return "Numer telefonu nie może być pustym łańcuchem znaków\n";

            return "";
        }

        public string ContactPhone
        {
            get
            {
                return contactPhone;
            }

            set
            {
                contactPhone = value;
            }
        }

        private int contactMinutesSpent;

        public string ValidateMinutesSpent(int newMinutes)
        {
            if (newMinutes < 0)
                return "Liczba minut musi być większa niż 0\n";

            return "";
        }

        public int ContactMinutesSpent
        {
            get
            {
                return contactMinutesSpent;
            }

            set
            {
                contactMinutesSpent = value;
            }
        }

        public Contact(string name, string address, string phone)
        {
            // errorMessage zawiera kompletny komunikat błędu
            string errorMessage = "";

            // error zawiera komunikat wygenerowany przez każdą walidację    
            string error;

            // walidacja nazwy
            error = ValidateName(name);
            // jeśli nazwa jest nieprawidłowa, łańcuch znaków error zawiera powód
            if (error != "")
                // jeśli dotarliśmy tutaj, w nazwie jest błąd
                errorMessage = error;

            // walidacja adresu
            error = ValidateAddress(address);
            // jeśli adres jest nieprawidłowy, łańcuch znaków error zawiera powód
            if (error != "")
                // jeśli dotarliśmy tutaj, w adresie jest błąd
                // dodajemy go do raportu o błędach
                errorMessage = errorMessage + error;

            // walidacja numeru telefonu
            error = ValidatePhone(phone);
            // jeśli numer telefonu jest nieprawidłowy, łańcuch znaków error zawiera powód
            if (error != "")
                // jeśli dotarliśmy tutaj, w numerze telefonu jest błąd
                // dodajemy go do raportu o błędach
                errorMessage = errorMessage + error;

            // jeśli errorMessage nie jest pustym łańcuchem znaków, coś poszło źle
            if (errorMessage != "")
                // porzucenie konstruowania poprzez rzucenie wyjątku
                throw new Exception(errorMessage);

            this.ContactName = name;
            this.ContactAddress = address;
            this.ContactPhone = phone;
            this.contactMinutesSpent = 0;
        }
    }

    void makeTestData()
    {
        string[] testNames = {
    "Rob", "Marysi", "Dawid", "Joanna",
    "Szymon", "Konrad", "Helena", "Nela",
    "Amanda", "Sandra" };

        // the number of minutes for contacts
        int minutes = 0;

        foreach (string name in testNames)
        {
            Contact newContact = new Contact(name: name,
                address: name + " dom",
                phone: name + " telefon");
            newContact.ContactMinutesSpent = minutes;
            minutes = minutes + 30;
            storeContact(newContact);
        }
    }

    string SAVE_NAME = "TimeTracker1.json";

    List<Contact> contacts = new List<Contact>();

    void storeContact(Contact contact)
    {
        contacts.Add(contact);
        storeAllContacts();
    }

    void storeAllContacts()
    {
        string json = JsonConvert.SerializeObject(contacts);

        SnapsEngine.SaveStringToLocalStorage(itemName: SAVE_NAME, itemValue: json);
    }

    void loadAllContacts()
    {
        string json = SnapsEngine.FetchStringFromLocalStorage(SAVE_NAME);

        if (json == null)
        {
            // If we get here there is no string in local storage
            SnapsEngine.WaitForButton("Utworzono pustą pamięć dla Rejestru czasu pracy");
            contacts = new List<Contact>();
        }
        else
        {
            contacts = JsonConvert.DeserializeObject<List<Contact>>(json);
        }
    }

    void newContact()
    {
        SnapsEngine.SetTitleString("Nowy kontakt");

        string errorMessage;
        string name;

        do
        {
            name = SnapsEngine.ReadString("Wpisz nazwę nowego kontaktu");
            errorMessage = Contact.ValidateName(name);
            if (errorMessage != "")
            {
                SnapsEngine.DisplayString(errorMessage);
                SnapsEngine.WaitForButton("Spróbuj ponownie");
                SnapsEngine.DisplayString("");
            }
        } while (errorMessage != "");

        string address;

        do
        {
            address = SnapsEngine.ReadMultiLineString("Wpisz adres kontaktu");
            errorMessage = Contact.ValidateAddress(address);
            if (errorMessage != "")
            {
                SnapsEngine.DisplayString(errorMessage);
                SnapsEngine.WaitForButton("Spróbuj ponownie");
                SnapsEngine.DisplayString("");
            }
        } while (errorMessage != "");

        string phone;

        do
        {
            phone = SnapsEngine.ReadString("Wpisz telefon kontaktu");
            errorMessage = Contact.ValidatePhone(phone);
            if (errorMessage != "")
            {
                SnapsEngine.DisplayString(errorMessage);
                SnapsEngine.WaitForButton("Spróbuj ponownie");
                SnapsEngine.DisplayString("");
            }
        } while (errorMessage != "");

        Contact newContact = new Contact(name: name, address: address, phone: phone);

        storeContact(newContact);

        storeAllContacts();

        SnapsEngine.DisplayString("Kontakt został zapisany");

    }

    void findContact()
    {
        SnapsEngine.SetTitleString("Znajdź kontakt");

        string name = SnapsEngine.ReadString("Wpisz nazwę kontaktu");

        string resultString = "Nie znaleziono kontaktu";

        foreach (Contact contact in contacts)
        {
            if (contact.ContactName == name)
            {
                resultString =
                    "Nazwa: " + contact.ContactName + "\n" +
                    "Adres: " + contact.ContactAddress + "\n" +
                    "Telefon: " + contact.ContactPhone + "\n" +
                    "Minuty: " + contact.ContactMinutesSpent.ToString();
                break;
            }
        }
        SnapsEngine.DisplayString(resultString);
        SnapsEngine.WaitForButton("Dalej");
        SnapsEngine.DisplayString("");
    }

    void addMinutes()
    {
        SnapsEngine.SetTitleString("Dodaj minuty");

        string name = SnapsEngine.ReadString("Wpisz nazwę kontaktu");
        int minutes = SnapsEngine.ReadInteger("Wpisz minuty dla kontaktu");

        string resultString = "Nie znaleziono kontaktu";

        for (int position = 0; position < contacts.Count; position = position + 1)
        {
            if (contacts[position].ContactName == name)
            {
                resultString = "Liczba dodanych minut: " + minutes + "\n" +
                    "do " + name;
                contacts[position].ContactMinutesSpent = contacts[position].ContactMinutesSpent + minutes;
                break;
            }
        }

        storeAllContacts();

        SnapsEngine.DisplayString(resultString);
        SnapsEngine.WaitForButton("Dalej");
        SnapsEngine.DisplayString("");
    }

    void displaySummary()
    {
        SnapsEngine.SetTitleString("Wyświetl podsumowanie");

        for (int pass = 0; pass < contacts.Count - 1; pass = pass + 1)
        {
            for (int i = 0; i < contacts.Count - 1; i = i + 1)
            {
                if (contacts[i].ContactMinutesSpent < contacts[i + 1].ContactMinutesSpent)
                {
                    // the elements are in the wrong order, need to swap them round
                    Contact temp = contacts[i];
                    contacts[i] = contacts[i + 1];
                    contacts[i + 1] = temp;
                }
            }
        }

        string result = "";
        int listLimit;

        if (contacts.Count < 5)
            listLimit = contacts.Count;
        else
            listLimit = 5;

        for (int position = 0; position < listLimit; position = position + 1)
        {
            if (contacts[position].ContactName == null)
                continue;
            result = result + contacts[position].ContactName +
                ":" + contacts[position].ContactMinutesSpent + "\n";
        }

        SnapsEngine.SetTitleString("Elementy kontaktu");

        SnapsEngine.DisplayString(result);

        SnapsEngine.WaitForButton("Dalej");

        SnapsEngine.DisplayString("");
    }

    public void StartProgram()
    {


        ////Use these statements to make test data 
        //makeTestData();
        //storeAllContacts();

        loadAllContacts();

        while (true)
        {
            // Clear the display 
            SnapsEngine.SetTitleString("Rejestr czasu pracy");
            SnapsEngine.DisplayString("");

            string command = SnapsEngine.SelectFrom4Buttons("Nowy kontakt", "Znajdź kontakt",
                "Dodaj minuty", "Wyświetl podsumowanie");

            switch (command)
            {
                case "Nowy kontakt":
                    newContact();
                    break;

                case "Znajdź kontakt":
                    findContact();
                    break;

                case "Dodaj minuty":
                    addMinutes();
                    break;

                case "Wyświetl podsumowanie":
                    displaySummary();
                    break;
            }
        }
    }
}
